//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PassthroughUseCase.h"
#import "Utils.h"
NS_ASSUME_NONNULL_BEGIN

@interface PassthroughUseCasePage : UIViewController

@property (weak, nonatomic) IBOutlet            UIView *topView;
@property (weak, nonatomic) IBOutlet            UIView *bottomView;

@property (weak, nonatomic) IBOutlet            UIButton *startDemoButton;

@property (weak, nonatomic) IBOutlet            UITextView *topText; //TextWriteSRAM
@property (weak, nonatomic) IBOutlet            UITextView *bottomText; //TextReadSRAM

@property (weak, nonatomic) IBOutlet            UIView *configDropDownList;

@property (weak, nonatomic) IBOutlet            UIView *MainDemoView;

@property (weak, nonatomic) IBOutlet            UILabel *textLog;
@property (weak, nonatomic) IBOutlet            UILabel *textDirection;

- (IBAction)navBarButtonClick:                  (id)sender;
- (IBAction)setI2cSlaveModeOptionSelected:      (UIGestureRecognizer *)sender;
- (IBAction)setI2cMasterModeOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)setGPIOPWMModeOptionSelected:       (UIGestureRecognizer *)sender;
- (IBAction)getUseCaseCongifOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)startDemoButtonClick:               (UIButton *)sender;
- (void) writeLog:                              (bool *) isWrite direction: (NSData                                               *) resp;

@end

NS_ASSUME_NONNULL_END
